#include "../generator.h"
#include "../bdtypes.h"
#include "../bdfunc.h"
#include "../bdglobal.h"

#define FOND_Z (1.f)
static GrVertex Fond1 = {0.f,0.f,FOND_Z,  255,128,128,   0,128.f,1.f/FOND_Z,{0.f,0.f, 1.f}};
static GrVertex Fond2 = {320.f,0.f,FOND_Z,   128,255,128,   0,128.f,1.f/FOND_Z,{256.f,0,1.f}};
static GrVertex Fond3 = {320.f,240.f,FOND_Z,   64,64,192,   0,128.f,1.f/FOND_Z,{256.f,256.f,1.f}};
static GrVertex Fond4 = {0,240.f,FOND_Z,   64,64,192,   0,128.f,1.f/FOND_Z,{0.f,256.f,1.f}};

static GrVertex Fond5 = {320.f,0.f,FOND_Z,  255,128,128,   0,128.f,1.f/FOND_Z,{0.f,0.f, 1.f}};
static GrVertex Fond6 = {640.f,0.f,FOND_Z,   128,255,128,   0,128.f,1.f/FOND_Z,{256.f,0,1.f}};
static GrVertex Fond7 = {640.f,240.f,FOND_Z,   64,64,192,   0,128.f,1.f/FOND_Z,{256.f,256.f,1.f}};
static GrVertex Fond8 = {320,240.f,FOND_Z,   64,64,192,   0,128.f,1.f/FOND_Z,{0.f,256.f,1.f}};

static GrVertex Fond9 = {0.f,240.f,FOND_Z,  255,128,128,   0,128.f,1.f/FOND_Z,{0.f,0.f, 1.f}};
static GrVertex Fond10 = {320.f,240.f,FOND_Z,   128,255,128,   0,128.f,1.f/FOND_Z,{256.f,0,1.f}};
static GrVertex Fond11 = {320.f,480.f,FOND_Z,   64,64,192,   0,128.f,1.f/FOND_Z,{256.f,256.f,1.f}};
static GrVertex Fond12 = {0,480.f,FOND_Z,   64,64,192,   0,128.f,1.f/FOND_Z,{0.f,256.f,1.f}};

static GrVertex Fond13 = {320.f,240.f,FOND_Z,  255,128,128,   0,128.f,1.f/FOND_Z,{0.f,0.f, 1.f}};
static GrVertex Fond14 = {640.f,240.f,FOND_Z,   128,255,128,   0,128.f,1.f/FOND_Z,{256.f,0,1.f}};
static GrVertex Fond15 = {640.f,480.f,FOND_Z,   64,64,192,   0,128.f,1.f/FOND_Z,{256.f,256.f,1.f}};
static GrVertex Fond16 = {320.f,480.f,FOND_Z,   64,64,192,   0,128.f,1.f/FOND_Z,{0.f,256.f,1.f}};

void LInit_Fabfou()
{
	PrepareTextureFromArray(g_FabfouPic, 256, 256, &g_TextureFabfou);
	PrepareTextureFromArray(g_Gauche1Pic, 256, 256, &g_TextureGauche1);
	PrepareTextureFromArray(g_Gauche2Pic, 256, 256, &g_TextureGauche2);
	PrepareTextureFromArray(g_Droite1Pic, 256, 256, &g_TextureDroite1);
	PrepareTextureFromArray(g_Droite2Pic, 256, 256, &g_TextureDroite2);
}

void QInit_Fabfou()
{
	grDepthBufferMode(GR_DEPTHBUFFER_DISABLE);
	grAlphaCombine(GR_COMBINE_FUNCTION_BLEND_OTHER, GR_COMBINE_FACTOR_ONE,
					GR_COMBINE_LOCAL_NONE, GR_COMBINE_OTHER_CONSTANT, FXFALSE);
	grAlphaBlendFunction(GR_BLEND_ONE, GR_BLEND_ZERO,
							GR_BLEND_ONE, GR_BLEND_ZERO);
	grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
					GR_COMBINE_FACTOR_ONE,
					GR_COMBINE_LOCAL_ITERATED, GR_COMBINE_OTHER_TEXTURE, FXFALSE);
	grCullMode(GR_CULL_DISABLE);

	grChromakeyMode(GR_CHROMAKEY_DISABLE);
	grFogMode(GR_FOG_DISABLE);

	DownloadTexture(&g_TextureFabfou);
	DownloadTexture(&g_TextureGauche1);
	DownloadTexture(&g_TextureGauche2);
	DownloadTexture(&g_TextureDroite1);
	DownloadTexture(&g_TextureDroite2);
}

void Effect_Fabfou()
{
	SelectTexture(g_TextureGauche1);
	grDrawTriangle(&Fond1, &Fond2, &Fond3);
	grDrawTriangle(&Fond3, &Fond4, &Fond1);

	SelectTexture(g_TextureDroite1);
	grDrawTriangle(&Fond5, &Fond6, &Fond7);
	grDrawTriangle(&Fond7, &Fond8, &Fond5);

	SelectTexture(g_TextureGauche2);
	grDrawTriangle(&Fond9, &Fond10, &Fond11);
	grDrawTriangle(&Fond11, &Fond12, &Fond9);

	SelectTexture(g_TextureDroite2);
	grDrawTriangle(&Fond13, &Fond14, &Fond15);
	grDrawTriangle(&Fond15, &Fond16, &Fond13);
}

void ByeBye_Fabfou()
{
	FreeTexture(&g_TextureDroite2);
	FreeTexture(&g_TextureDroite1);
	FreeTexture(&g_TextureGauche2);
	FreeTexture(&g_TextureGauche1);
	FreeTexture(&g_TextureFabfou);
}